 ; Ŀ
 ;   Find and mark all blocks or all occurrences of a specified block.     
 ;   Copyright 1991, 2006, 2007, 2010 by Rocket Software Ltd.              
 ;   Note that anonymous blocks appear at the end of the dialog box list,  
 ;   but dimensions don't, as there will only be one of any name.          
 ;   Valuable for those times when you can't think...of...you know.        
 ; 

 ; Ŀ
 ;   Blisto - get a list of the names of all blocks in the drawing.        
 ;   Takes no arguments, calls nothing, returns a list.                    
 ;   This includes anonymous blocks, whose names begin with *, but         
 ;   apparently dimension block names begin with *D and can thus be        
 ;   ditched.  Also xrefs are not included.                                
 ; 
 (DEFUN BLISTO (/ rew nexb namm blist)
  (setq rew T)
  (while (setq nexb (tblnext "block" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 nexb)))
         (setq isx (isxnam namm))
;         (if (= (substr namm 1 2) "*D")
;             (progn
;                  (write-line "\n")
;                  (print nexb)
;                  (print (setq entt (entget (cdr (assoc -2 nexb)))))
;                  (print (setq entt (entget (cdr (assoc 330 entt)))))
;                  (print (setq enam (cdr (assoc 360 entt))))
;                  (print (entget enam))))
         (if (and (/= (substr namm 1 2) "*D")
                  (not isx))
             (setq blist (cons namm blist))))
 blist)
 ; Ŀ
 ;   Blisto end.                                                           
 ; 

 ; Ŀ
 ;   Cindi - mark each entity in an ss.                                    
 ;   Arguments: Ss, a selection set.                                       
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN CINDI (ss rad colo / len num so pa)
  (setq len (strcat "/" (itoa (sslength ss))))
  (setq num 0)
  (while (setq so (ssname ss num))
         (setq num (1+ num))
         (grtext -2 (strcat (itoa num) len))
         (setq pa (cdr (assoc 10 (entget so))))
         (mark pa rad colo))
 (princ))
 ; Ŀ
 ;   Cindi end.                                                            
 ; 

 ; Ŀ
 ;   Drosop - rewrite a dcl file on the fly.                               
 ;   Arguments: Filnam, a dcl file name.                                   
 ;              Widnum, the desired dialog box width.                      
 ;              Htnum, the desired dialog box height.                      
 ;   Calls Yout, Word1, and Pout.  Returns nothing.                        
 ; 
 (DEFUN DROSOP (filnam widnum htnum / comlst num sub gnulst)
 ; Ŀ
 ;   The dialog box height is greater than the list length.                
 ; 
  (setq htnum (+ htnum 3)) ; for bottom lines plus one space
 ; Ŀ
 ;   The dialog box can't be bigger than the screen.                       
 ; 
  (cond ((< widnum 32)
         (setq widnum 32))
        ((> widnum 165)
         (setq widnum 165)))   ; maximum width is 165 (on 1024 x 768)
  (cond ((< htnum 10)
         (setq htnum 10))
        ((> htnum 50)
         (setq htnum 50)))     ; maximum height is 50 (on 1024 x 768)
 ; Ŀ
 ;   Open, read, modify and rewrite the file.                              
 ; 
  (setq filnam (findfile "Fibl.dcl"))
  (setq comlst (yout filnam))
  (setq num 0)
  (while (setq sub (nth num comlst))
         (setq num (1+ num))
         (cond ((= (word1 sub) "width")
                (setq sub (strcat "                 width = "
                                  (itoa widnum) ";")))
               ((= (word1 sub) "height")
                (setq sub (strcat "                 height = "
                                  (itoa htnum) ";}"))))
         (setq gnulst (append gnulst (list sub))))
  (pout gnulst filnam)
 (princ))
 ; Ŀ
 ;   Drosop end.                                                           
 ; 

 ; Ŀ
 ;   Isloca - see if a string is lower case.                               
 ;   Not currently called.                                                 
 ;   Takes one argument, a string, returns T = Lc or nil = not entirely.   
 ; 
 (DEFUN ISLOCA (str)
  (if (= str (strcase str t)) T nil))
 ; Ŀ
 ;   Isloca end.                                                           
 ; 

 ; Ŀ
 ;   Isxnam: see if a given block is an xref.                              
 ;   Argument: Blnam, the block name.                                      
 ;   Returns T: it was an xref, or nil: it wasn't, or no such block is     
 ;   is defined in the drawing.                                            
 ; 
 (DEFUN ISXNAM (blnam / isxrf xp dat)
  (if (setq dat (tblsearch "block" blnam))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf4 (logand xp 4))      ; an xref
           (setq isxr16 (logand xp 16))))   ; externally dependent
 (if (or (= isxrf4 4) (= isxr16 16)) T ()))
 ; Ŀ
 ;   Isxnam end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lbox - display a list of strings in a dialog box.          
 ;   Arguments: Styldt, the list of strings to display.                    
 ;              Dclfil, the dcl file name.                                 
 ;              Dclnam, the dialog box name in the dcl file.               
 ;              Prom, the type for the number of things found prompt.      
 ;              Dianam, the dialog box title.                              
 ;   Returns a text string or nil.                                         
 ; 
 (DEFUN LBOX (styldt dclfil dclnam prom dianam / fpath dcl_id num numf filnam
                                                       fnam malist findx ret)
  (setq dcl_id (load_dialog dclfil))
  (new_dialog dclnam dcl_id)      ; must come before data for list box
  (set_tile "diabox" dianam)
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")         ; read ltype data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " " prom))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a text string or nil.                                          
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Lbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Lsdata - get the maximum string length in a list of strings.          
 ;   Arguments: Lista, a list.                                             
 ;   Calls nothing, returns a number (0 if there were no strings.)         
 ; 
 (DEFUN LSDATA (lista / num maxa sub len)
  (setq num 0)
  (setq maxa 0)
  (while (setq sub (nth num lista))
         (setq num (1+ num))
         (if (and (= (type sub) 'STR)
                  (> (setq len (strlen sub)) maxa))
             (setq maxa len)))
 maxa)
 ; Ŀ
 ;   Lsdata end.                                                           
 ; 
         
 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   OneUp - Upper case the first character in a string.                   
 ;   Takes one argument, a string, returns a modified string.              
 ; 
 (DEFUN ONEUP (str)
  (strcat (strcase (substr str 1 1)) (substr str 2)))
 ; Ŀ
 ;   Oneup end.                                                            
 ; 

 ; Ŀ
 ;   Pout - write a list of strings to a file.                             
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN POUT (lista filnam / fn sub)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (write-line sub fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Pout end.                                                             
 ; 

 ; Ŀ
 ;   Radget - get a marker length.                                         
 ;   Arguments: Pt, the drag line start point.                             
 ;   Returns a real.                                                       
 ; 
 (DEFUN RADGET (pt / rad)
  (if (null pt) (setq pt (getvar "viewctr")))
  (if (null (setq rad (getdist pt "\nMarker length (<Return> for preset): ")))
      (setq rad (/ (getvar "viewsize") 25)))
 rad)
 ; Ŀ
 ;   Radget end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a name."))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Word1 - get the first word in a string.                               
 ;   Arguments: Str, a string.                                             
 ;   Calls nothing, returns a word or "".                                  
 ; 
 (DEFUN WORD1 (str / pos chra)
  (while (= (substr str 1 1) " ")
         (setq str (substr str 2)))
  (setq pos 1)
  (while (and (/= (setq chra (substr str pos 1)) "")
              (/= chra " "))
         (setq pos (1+ pos)))
  (cond ((= (substr str pos 1) " ")
         (setq str (substr str 1 (1- pos))))
        (t
         (setq str (substr str 1 pos)))))
 ; Ŀ
 ;   Word1 end.                                                            
 ; 

 ; Ŀ
 ;   Yout - suck a text file into a list.                                  
 ;   Arguments: filnam, a filename.                                        
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN YOUT (filnam / fn linn malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (setq malist (append malist (list linn))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Yout end.                                                             
 ; 

 ; Ŀ
 ;   Fibl.                                                                 
 ; 
 (DEFUN C:FIBL (/ enampt entt pt bl nogo malist ss widnum htnum)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Ask to select a block or use the dialog box.                          
 ; 
  (if (setq enampt (entsel "Select a block or <Return> for the list: "))
      (progn
           (setq entt (entget (car enampt)))
           (setq pt (cadr enampt))
           (setq bl (cdr (assoc 2 entt)))
           (if bl
               (prompt (oneup bl))
               (progn
                    (write-line "\nThat was not a block.")
                    (setq nogo T)))))
 ; Ŀ
 ;   If we don't have a block name in Bl then get a list of all blocks.    
 ; 
  (if (and (null bl) (null enampt))
      (progn
           (setq malist (blisto))
 ; Ŀ
 ;   Put the list in order.                                                
 ; 
           (if malist (setq malist (acad_strlsort malist)))
 ; Ŀ
 ;   Move anonymous block names to the end of the list.                    
 ;   Blisto should already have removed dimension block names.             
 ; 
           (while (and (setq sub (car malist))
                       (= (substr sub 1 1) "*"))
                  (setq malist (append (cdr malist) (list (car malist)))))
 ; Ŀ
 ;   Prefix the All Blocks selection.                                      
 ; 
           (if malist 
               (setq malist (cons "*Mark All Blocks*" malist))
               (setq malist (list " Apparently there are no blocks.")))
 ; Ŀ
 ;   Get the list length and maximum string length, call Drosop to         
 ;   rewrite the .dcl file to reflect these numbers.                       
 ; 
           (setq htnum (length malist))
           (setq widnum (lsdata malist))
           (drosop "fibl.dcl" widnum htnum)
 ; Ŀ
 ;   And call the dialog box to get a block name.                          
 ; 
           (setq bl (lbox malist "fibl.dcl" "fibl" "Blocks." "Block to Find"))))
 ; Ŀ
 ;   Either get all blocks...                                              
 ; 
  (cond ((= bl "*Mark All Blocks*")
         (setq ss (ssget "x" '((0 . "insert")))))
 ; Ŀ
 ;   ... or escape a leading * so that hatch blocks can be located         
 ;   and get a selection set of that type.                                 
 ; 
        (bl
         (if (= (substr bl 1 1) "*")
             (setq ss (ssget "x" (list (cons 2 (strcat "`" bl)))))
             (setq ss (ssget "x" (list (cons 2 bl)))))))
 ; Ŀ
 ;   Mark all blocks that were found.                                      
 ; 
  (if ss (cindi ss (radget pt) 7))
 ; Ŀ
 ;   Explain the results.                                                  
 ; 
  (if bl (setq bl (oneup bl)))
  (cond ((and ss (= bl "*Mark All Blocks*"))
         (write-line (strcat "\nBlock Insertions Found: "
                             (itoa (sslength ss)))))
        (ss
         (write-line (strcat "\n" bl " blocks found: " (itoa (sslength ss)))))
        ((= bl "*Mark All Blocks*")
         (write-line "\nThere are no blocks inserted in this drawing."))
        ((= bl " Apparently there are no blocks."))
        (bl
         (write-line (strcat "\nThere are no insertions of " bl "."))))
 (princ))